import { data } from "@/data/data";
import Image from "next/image";
export default function Partners() {
  const platforms = data?.platforms;
  return (
    <>
      <section>
        <div className="bg-white flex flex-col items-center justify-center p-4">
          <div className="flex flex-wrap justify-center items-center gap-8 md:gap-30 max-w-5xl">
            {platforms.map((platform) => (
              <div
                key={platform.name}
                className="relative w-32 mt-10 h-auto md:w-40 transition-transform hover:scale-105 cursor-pointer"
              >
                <Image
                  src={platform.logo}
                  alt={`${platform.name} logo`}
                  width={150}
                  height={150}
                  className="object-contain panrtners-img"
                />
              </div>
            ))}
          </div>
        </div>
      </section>
    </>
  );
}
