"use client";
import dynamic from "next/dynamic";
import Image from "next/image";
const Card = dynamic(() => import("@/components/ui/Card"));
export default function Deals({ data, imgsrc }) {
  return (
    <>
      <div className="container-fluid lg:p-6 md:p-0 p-5" id="order">
        <Image
          src={imgsrc}
          width={1400}
          alt=""
          className="object-contain w-full my-10"
          height={50}
        />
        <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-3 xxl:grid-cols-4 gap-8">
          {data?.map((item) => (
            <Card item={item} key={item?.id} />
          ))}
        </div>
      </div>
    </>
  );
}
