import { Api_Url } from "@/Domain/Domain";
const TOKEN = process.env.NEXT_PUBLIC_LARAVEL_API_TOKEN;
const BASE_URL = `${Api_Url}/api/selected-products-list?include=category,modifiers,modifiers.options,discounts&filter[category_id][]=9f1335aa-a4ab-4df6-99dc-2efa6eddc5a4, &filter[category_id][]=9f4b058a-1c6f-48cf-a9af-32354867c050`;
const BASE_URL2 = `${Api_Url}/api/regular-products-list?include=category,modifiers,modifiers.options,discounts&filter[category_id]=9f4b058a-1c6f-48cf-a9af-32354867c050`;
const Branches_URl = `${Api_Url}/api/branches`;
export async function fetchData() {
  try {
    const response = await fetch(BASE_URL, {
      // Caching options for Next.js
      next: { revalidate: 3600 },
      headers: {
        Authorization: `Bearer ${TOKEN}`, // Proper string interpolation
        "Content-Type": "application/json", // Optional, but often needed
      },
    });

    if (!response.ok) {
      throw new Error(`HTTP error! Status: ${response.status}`);
    }

    const data = await response.json(); // Make sure to parse the JSON
    return data;
  } catch (error) {
    console.error("Error fetching data:", error);
    return null;
  }
}
export async function fetchData2() {
  try {
    const response = await fetch(BASE_URL2, {
      // Caching options for Next.js
      next: { revalidate: 3600 },
      headers: {
        Authorization: `Bearer ${TOKEN}`, // Proper string interpolation
        "Content-Type": "application/json", // Optional, but often needed
      },
    });

    if (!response.ok) {
      throw new Error(`HTTP error! Status: ${response.status}`);
    }

    const data = await response.json(); // Make sure to parse the JSON
    return data;
  } catch (error) {
    console.error("Error fetching data:", error);
    return null;
  }
}
export async function fetchBranchData() {
  try {
    const response = await fetch(Branches_URl, {
      // Caching options for Next.js
      next: { revalidate: 3600 },
      headers: {
        Authorization: `Bearer ${TOKEN}`, // Proper string interpolation
        "Content-Type": "application/json", // Optional, but often needed
      },
    });
    if (!response.ok) {
      throw new Error(`HTTP error! Status: ${response.status}`);
    }
    const data = await response.json(); // Make sure to parse the JSON
    return data;
  } catch (error) {
    console.error("Error fetching data:", error);
    return null;
  }
}
