import Image from "next/image";
import CardDetail from "./CardDetail";
import { useModal } from "@/context/ModalContext";
import { IoMdAddCircle } from "react-icons/io";
export default function Card({ item }) {
  const { openModal, closeModal } = useModal();
  const compo = <CardDetail data={item} closeModal={closeModal} multi={true} />;
  const size = "large";
  const openCardModal = () => {
    openModal(compo, size);
  };
  return (
    <>
      <div
        onClick={openCardModal}
        className="shadow border w-full rounded-[25px] bg-white relative lg:hover:scale-105 hover:scale-105 duration-500 hover:shadow-md"
      >
        {item?.image && (
          <Image
            alt={item?.name}
            width={346}
            height={346}
            className="p-1 rounded-[25px] w-full"
            src={item?.image}
          />
        )}
        <div className="p-4">
          <span className="cursor-pointer">
            <h2 className="text-[1.2rem] text-kcred font-sans line-clamp-1 mb-1">
              {item?.name}
            </h2>
          </span>
          <div className="flex justify-between items-end w-100">
            <span className="cursor-pointer">
              <p className="text-[14px] font-[500] text-gray-600 leading-5 line-clamp-3 mb-2">
                {item?.description}
              </p>
            </span>
            <button className="hover:bg-cblack hover:text-white ms-2 relative top-6 rounded-tl-[3.5rem] rounded-br-lg rounded-tr-none rounded-bl-none btn-red mt-3 py-2 px-4 w-[70px] h-[70px] justify-center items-center flex uppercase">
              <IoMdAddCircle size={40} />
            </button>
          </div>
          <span className="cursor-pointer">
            <div className="flex gap-2">
              <div>
                <h2
                  className={`text-[1rem] font-sans text-cblack font-[500] ${
                    item?.discounts?.[0]?.discounted_price
                      ? "line-through opacity-60"
                      : null
                  }`}
                >
                  AED : {item?.price}
                </h2>
              </div>
              {item?.discounts?.[0]?.discounted_price ? (
                <div>
                  <h2 className="text-[1rem] font-sans text-cblack font-[500]">
                    AED : {item?.discounts?.[0]?.discounted_price}
                  </h2>
                </div>
              ) : null}
            </div>
          </span>
        </div>
      </div>
    </>
  );
}
