import { useCart } from "@/context/CartContext";
import CreatableSelect from "react-select/creatable";

export default function AreaSelect() {
  const { selectedOption, DlocationHandle, deliveryOptions } = useCart();
  return (
    <div className="px-5">
      <p className="text-cblack text-sm mb-2 font-medium">
        Please Select Location to CheckOUT
      </p>
      <CreatableSelect
        placeholder="Select your area..."
        isClearable
        options={deliveryOptions}
        value={selectedOption}
        onChange={DlocationHandle}
      />
    </div>
  );
}
