"use client";
import { useEffect, useState, useRef } from "react";
import { useClickAway } from "react-use";
import ViewCart from "../ui/ViewCart";
import YourCart from "../ui/YourCart";
import Image from "next/image";
import Link from "next/link";
import Orderbtn from "../ui/Orderbtn";
import BranchSelection from "../ui/BranchSelection";
import { IoLocation } from "react-icons/io5";

function Navbar({ data }) {
  const [isModalVisible, setIsModalVisible] = useState(false);
  const [isDataSaved, setIsDataSaved] = useState(false);
  const [open, setOpen] = useState(false);
  const [opencart, setOpencart] = useState(false);
  const [branch, setBranch] = useState(null);

  const ref = useRef(null);

  // Load branch on mount
  useEffect(() => {
    const savedBranch = localStorage.getItem("selectedBranch");
    if (savedBranch) {
      setBranch(JSON.parse(savedBranch));
      setIsModalVisible(false);
    } else {
      setIsModalVisible(true); // Show modal only if no saved branch
    }
  }, []);

  // Control body scroll on sidebar open
  useEffect(() => {
    if (typeof window !== "undefined" && window.document) {
      document.body.style.overflow = open ? "hidden" : "unset";
    }
  }, [open]);

  // Close sidebar/cart when clicking outside
  useClickAway(ref, () => {
    setOpen(false);
    setOpencart(false);
  });

  const toggleCart = () => setOpencart((prev) => !prev);

  const handleEditClick = () => {
    setBranch(null);
    setIsDataSaved(false);
    localStorage.removeItem("selectedBranch");
    setIsModalVisible(true);
  };
  return (
    <>
      <div className="container-fluid p-0 max-[380px]:p-0 md:my-4">
        <header className="flex py-2 px-2 sm:px-10 min-h-[70px] tracking-wide relative z-50 justify-center">
          <div className="md:block hidden w-full">
            <button
              className="btn-red flex items-center gap-2 w-[330px] justify-center text-[12px] md:text-sm px-1"
              onClick={handleEditClick}
            >
              <IoLocation onClick={handleEditClick} />
              {`${branch?.name || "Change Branch"}`}
            </button>
          </div>
          <div className="flex flex-wrap items-center justify-between gap-4 w-full">
            <Link
              href="/"
              className="lg:absolute max-lg:left-10 lg:top-2/4 lg:left-2/4 lg:-translate-x-1/2 lg:-translate-y-1/2"
            >
              <Image
                priority={true}
                height={200}
                width={300}
                src="/images/kcglogo.png"
                alt="logo"
                className="w-[157px] max-h-[60px] sm:w-[210px] lg:w-[260px] object-contain"
              />
            </Link>
          </div>

          <IoLocation
            className="text-kcred me-2 my-auto md:hidden"
            size={40}
            onClick={handleEditClick}
          />
          <Orderbtn />
        </header>
      </div>
      <YourCart open={opencart} toggleSidebar={toggleCart} />
      <ViewCart toggleCart={toggleCart} />
      <BranchSelection
        data={data}
        isModalVisible={isModalVisible}
        setIsModalVisible={setIsModalVisible}
        setIsDataSaved={setIsDataSaved}
        isDataSaved={isDataSaved}
        setBranch={setBranch}
        branch={branch}
      />
    </>
  );
}
export default Navbar;
