import Navbar from "@/components/layout/Navbar";
import ImgSlider from "@/sections/ImgSlider";
import Deals from "@/sections/Deals";
import FixedYourCard from "@/components/ui/FixedYourCard";
import { fetchBranchData, fetchData, fetchData2 } from "@/lib/api";
import Location from "@/sections/Location";
import ComboMeal from "@/sections/ComboMeal";
import FindWhatsapp from "@/sections/FindWhatsapp";
import ContactSection from "@/sections/ContactSection";
export const metadata = {
  title: "Kelly Cajun Grill Best Cajun Cuisine Restaurant in Dubai",
  description:
    "Craving bold Cajun flavors? Kelly Cajun Grill serves up the best spicy, southern-style dishes in Dubai. Fresh, flavorful, and unforgettable!",
  keywords: [
    "Cajun restaurant Dubai, Kelly Cajun Grill, best Cajun food Dubai, southern cuisine Dubai, spicy food Dubai, Cajun grill, Cajun flavors, Dubai restaurants",
  ],
};
export default async function HomePage() {
  const data = await fetchData();
  const data_asdasd = await fetchData2();
  const Branchdata = await fetchBranchData();
  const { combo_data } = data?.products;
  const { main_data } = data_asdasd?.products;
  return (
    <>
      <Navbar data={Branchdata?.data} />
      <ImgSlider />
      <ComboMeal />
      <FindWhatsapp />
      <div className="container-fluid p-0">
        <div className="grid grid-cols-1 sm:grid-cols-1 md:grid-cols-8 lg:grid-cols-8">
          <div className="lg:col-span-6 col-span-8 mb-10 max-w-[1760px] mx-auto">
            <Deals data={combo_data} imgsrc="/images/combanner.png" />
            <Deals data={main_data} imgsrc="/images/main_data.png" />
          </div>
          <div className="col-span-2 !lg:flex justify-end hidden lg:block">
            <FixedYourCard />
          </div>
        </div>
      </div>
      <Location />
      <ContactSection />
    </>
  );
}
