import { ModalProvider } from "@/context/ModalContext";
import { CartProvider } from "@/context/CartContext";
import localFont from "next/font/local";
import "../styles/globals.css";
import { SpringModal } from "@/components/ui/SpringModal";
import { fullUrl } from "@/data/data";
import NextTopLoader from "nextjs-toploader";
import { GoogleTagManager } from "@next/third-parties/google";
import WhatsappBtn from "@/components/layout/WhatsappBtn";

const myFont = localFont({
  src: [
    {
      path: "./fonts/ClashDisplay-Extralight.woff",
      weight: "300",
      style: "normal",
    },
    {
      path: "./fonts/ClashDisplay-Medium.woff",
      weight: "500",
      style: "normal",
    },
    {
      path: "./fonts/ClashDisplay-Regular.woff",
      weight: "600",
      style: "normal",
    },
    {
      path: "./fonts/ClashDisplay-Bold.woff",
      weight: "700",
      style: "normal",
    },
  ],
});
export const metadata = {
  metadataBase: new URL(fullUrl),
  openGraph: {
    siteName: "Kelly Cajun Grill Best Cajun Cuisine Restaurant in Dubai",
    locale: "en_US",
    type: "website",
  },
  icons: {
    icon: "/favicon.ico",
  },
  applicationName: "Kelly Cajun Grill Best Cajun Cuisine Restaurant in Dubai",
  referrer: "origin-when-cross-origin",
  alternates: {
    languages: {
      "en-US": "/",
    },
  },
};
const GTM = "GTM-PSXKB3TQ";
export default function RootLayout({ children }) {
  return (
    <html lang="en" className="md:custom-scrollbar">
      <head>
        {/* Meta Pixel Code */}
        <script
          dangerouslySetInnerHTML={{
            __html: `
              !function(f,b,e,v,n,t,s)
              {if(f.fbq)return;n=f.fbq=function(){n.callMethod?                         
              n.callMethod.apply(n,arguments):n.queue.push   
              (arguments)}; if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!
              0;n.version='2.0';n.queue=[];t=b.createElement(e);
              t.async=!0;t.src=v;s=b.getElementsByTagName(e)[0];
              s.parentNode.insertBefore(t,s)}(window, document,
              'script',
              'https://connect.facebook.net/en_US/fbevents.js');
              fbq('init', '918432056457983');
              fbq('track', 'PageView');
            `,
          }}
        />
        <noscript>
          <img
            height="1"
            width="1"
            style={{ display: "none" }}
            src="https://www.facebook.com/tr?id=918432056457983&ev=
            PageView&noscript=1"
          />
        </noscript>
        {/* End Meta Pixel Code */}
        <GoogleTagManager gtmId={GTM} />
      </head>
      <body className={`${myFont.className}`} cz-shortcut-listen="true">
        {/* <!-- Google Tag Manager (noscript) --> */}
        <noscript>
          <iframe
            src={`https://www.googletagmanager.com/ns.html?id=${GTM}`}
            height="1"
            width="1"
            style={{ display: "none" }}
          ></iframe>
        </noscript>
        {/* <!-- End Google Tag Manager (noscript) --> */}
        <CartProvider>
          <ModalProvider>
            <NextTopLoader
              color="#e2212d"
              initialPosition={0.08}
              height={2}
              crawl={true}
              showSpinner={false}
              easing="ease"
              speed={200}
              shadow="0 0 10px #e2212d,0 0 5px #e2212d"
              template='<div className="bar" role="bar"><div className="peg"></div></div> 
  <div className="spinner" role="spinner"><div className="spinner-icon"></div></div>'
              zIndex={1600}
              showAtBottom={false}
            />
            {children}
            <WhatsappBtn />
            <SpringModal />
          </ModalProvider>
        </CartProvider>
      </body>
    </html>
  );
}
